*Share of social classes in the population

*Tim Goedemé
*2020

/*
Note: not all results are used/displayed in the journal article.
See the book chapter at my homepage for more output.

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/


*/

global place1 <<data directory\2020-04\>>
global place2 <<directory for output ...\StataOutput\>>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

*Create file for analysis

foreach ctry of global countries {
	di "`ctry'", _continue

	forvalues year=2004(1)2018 {
		di "`ctry': `year'"
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
		    quietly {
				use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
				if `year'<2009 keep country year hid pid pl030 px040
				else keep country year hid pid pl031
				cap drop _merge
				merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta"
				cap drop _merge
				drop emp*
				merge 1:1 country hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", keepusing(active actage hystd arop60)
				cap drop _merge
				
				gen resp = (px040==1 | px040==2)
				
				compress
				save "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", replace
			}
		}
	}
}


*Share of each social class in active population at working age (selected respondents only where relevant)
***********************************************************************************************************$

*Estimation

local varlist esec88 esec08
foreach v of local varlist {
	di "***`v'***"
	di "****************"
	cap mat drop res_`v'1
	cap mat drop res_`v'2
	
	foreach ctry of global countries {
		di "`ctry'"
		
		cap mat drop tempmat1
		cap mat drop tempmat2
		quietly {
			
			if "`v'"=="esec88" {
				forvalues year=2004(1)2011 {
					noi di "`year'", _continue
					local val1=.
					local val2=.
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta"
					
					if _rc==0 {
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
						
						svyset psu1 [pw=pb040], strata(strata1)
						qui: gen sub = (active==1 & actage==1 & resp==1)
						
						cap mat drop temp
						qui: ta `v'
						if r(r)!=0 {
							qui: subprop3 `v', na(temp) subpop(if sub==1)
							local r=rowsof(temp) - 1
							local jaren `year'
							forvalues x=1/`r' {
								local jaren `jaren' \ `year'
							}
							mat def ymat = `jaren'
							
							mat def temp = temp, ymat
							mat rownames temp = `ctry'
							mat def res_`v'1 = nullmat(res_`v'1) \ temp
						}
					}
				}
			
			}
			
			else {
			    cap mat drop tempmat1
				cap mat drop tempmat2
				forvalues year=2010(1)2018 {
					noi di "`year'", _continue
					local val=.
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
					use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
						
						svyset psu1 [pw=pb040], strata(strata1)
						qui: gen sub = (active==1 & actage==1 & resp==1)
						
						cap mat drop temp
						qui: ta `v'
						if r(r)!=0 {
							qui: subprop3 `v', na(temp) subpop(if sub==1)
							local r=rowsof(temp) - 1
							local jaren `year'
							forvalues x=1/`r' {
								local jaren `jaren' \ `year'
							}
							mat def ymat = `jaren'
							
							mat def temp = temp, ymat
							mat rownames temp = `ctry'
							mat def res_`v'1 = nullmat(res_`v'1) \ temp
						}
							
					}
				}
			}
		}
	}
}

*Export data

foreach v of local varlist {
	di "***`v'***"
	global names: rownames res_`v'1
	clear
	svmat res_`v'1, names(col)
	gen country=""
	local counter
	foreach r of global names {
	    local counter=`counter'+1
	    replace country="`r'" in `counter'
	}
	compress
	save "${place2}\res_`v'1.dta", replace
}

*Rearrange data and create graphs

use "${place2}res_esec881.dta", clear
cap rename c1 year
drop SE LB UB DF
reshape wide Estimate, i(country year) j(esec88)
forvalues x=1/9 {
	cap rename Estimate`x' ESeC_`x'
}
gen ESeC = "ESeC-88"
save "${place2}res_esec881_bis.dta", replace

use "${place2}res_esec081.dta", clear
cap rename c1 year
drop SE LB UB DF
reshape wide Estimate, i(country year) j(esec08)
forvalues x=1/9 {
	cap rename Estimate`x' ESeC_`x'
}
gen ESeC = "ESeC-08"
save "${place2}res_esec081_bis.dta", replace

append using "${place2}res_esec881_bis.dta"
gen order = (ESeC=="ESeC-08")
sort country year order

replace year = 2011.5 if year==2011 & order==1

order ESeC_9 ESeC_8 ESeC_7 ESeC_6 ESeC_5 ESeC_4 ESeC_3 ESeC_2 ESeC_1

graph bar ESeC_* if country=="AT", over(year) stack pcycle(15)

replace year =2011 if year==2011.5

forvalues x=1/9 {
	di "****ESEC_`x'****"
	sum ESeC_`x' if year==2011 & order==0 & (country!="BG" & country!="FI" & country!="IE")
	sum ESeC_`x' if year==2011 & order==1 & (country!="BG" & country!="FI" & country!="IE")
}

cap drop first
cap drop last

bysort country order: egen first=min(year)
bysort country order: egen last=max(year)

/* cap drop first88
gen first88 = first if order==0
cap drop last88
gen last88 = last if order==0

cap drop first08
gen first08 = first if order==1
cap drop last08
gen last08 = last if order==1 

bysort country: egen first08=max(first*order)
bysort country: egen last08=max(last*order)

cap drop order1
gen order1 = 1-order

bysort country: egen first88=max(first*order1)
bysort country: egen last88=max(last*order1)

drop first last order1  */

reshape wide ESeC_*, i(country ESeC) j(year)
replace first=2005 if country!="SE" & order==0 & first==2004

local max=_N
forvalues x=1/9 {
	cap drop cESeC_`x'
	gen cESeC_`x'=.
	forvalues r=1/`max' {
		local val1 = first[`r']
		local val2 = last[`r']
		replace cESeC_`x' in `r'= (ESeC_`x'`val2' / ESeC_`x'`val1')^(1/(`val2'-`val1'))
	}
}


local max=_N
forvalues x=1/9 {
	cap drop cabESeC_`x'
	gen cabESeC_`x'=.
	forvalues r=1/`max' {
		local val1 = first[`r']
		local val2 = last[`r']
		replace cabESeC_`x' in `r'= (ESeC_`x'`val2' - ESeC_`x'`val1')/(`val2'-`val1')
	}
}
